<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TradeGroup extends Model 
{

    protected $table = 'trade_groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'surname', 'slug', 'icon', 'description', 'cover_file');

    public function trades()
    {
        return $this->hasMany('App\Models\Trade', 'trade_group_id');
    }

}